* THIS DO-FILE IS FOR THE ETHNICITY-LEVEL ANALYSIS
* IT CREATES OUTPUT FOR TABLE 2 AND APPENDIX TABLE B6

use data\EthnographicAtlas.dta, clear

*_________________________________________________________________________
*	Table 2: Ethnicities’ Kinship and Local Democratic Traditions


* Sets of covariates
local a avg_rugged co_latitude distance_to_coast suit_agri 
local a2 annual_mean_temp annual_mean_prec elevation slope
local b co_fishing co_husbandry co_agriculture
local c co_prop_land co_prop_mov
local d co_settlementcomplex co_irrigation co_hierarchy

preserve
drop if avg_rugged==. | co_latitude==. | distance_to_coast==. | suit_agri==. 
drop if co_fishing==. | co_husbandry==. | co_agriculture==.
drop if co_prop_land==. | co_prop_mov==.
drop if co_settlementcomplex==. | co_irrigation==. | co_hierarchy==.

*Panel 1: Cousin narriage preferred
local x CousinMarriage_Pref
eststo: xi: reg co_succession `x'      , cluster(language_family)
eststo: xi: reg co_succession `x' `a'  , cluster(language_family)
eststo: xi: reg co_succession `x' `a' `a2' , cluster(language_family)
psacalc delta `x', rmax(0.28) beta(0) 
eststo: xi: reg co_succession `x' `a' `a2' `b' , cluster(language_family)
eststo: xi: reg co_succession `x' `a' `a2' `b' `c' , cluster(language_family)
eststo: xi: reg co_succession `x' `a' `a2' `b' `c' `d', cluster(language_family)
psacalc delta `x', rmax(0.28) beta(0) 
eststo: xi: reg co_succession `x' `a' `a2' `b' `c' `d' i.therm_clim, cluster(language_family)
psacalc delta `x', rmax(0.28) beta(0) 
eststo: xi: reg co_succession `x' `a' `a2' `b' `c' `d' i.therm_clim co_deepchrist, cluster(language_family)
psacalc delta `x', rmax(0.28) beta(0) 
esttab using tables\Table2_Panel1.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 ar2 aic bic se cells(b(star fmt(2)) se(par fmt(2))) scalars(F)
eststo clear


*Panel 2: Cousin-term differentiation
local x CousinTerm_Dif
eststo: xi: reg co_succession `x'      , cluster(language_family)
eststo: xi: reg co_succession `x' `a'  , cluster(language_family)
eststo: xi: reg co_succession `x' `a' `a2' , cluster(language_family)
psacalc delta `x', rmax(0.28) beta(0) 
eststo: xi: reg co_succession `x' `a' `a2' `b' , cluster(language_family)
eststo: xi: reg co_succession `x' `a' `a2' `b' `c' , cluster(language_family)
eststo: xi: reg co_succession `x' `a' `a2' `b' `c' `d', cluster(language_family)
psacalc delta `x', rmax(0.28) beta(0) 
eststo: xi: reg co_succession `x' `a' `a2' `b' `c' `d' i.therm_clim, cluster(language_family)
psacalc delta `x', rmax(0.28) beta(0) 
eststo: xi: reg co_succession `x' `a' `a2' `b' `c' `d' i.therm_clim co_deepchrist, cluster(language_family)
psacalc delta `x', rmax(0.28) beta(0) 
esttab using tables\Table2_Panel2.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 ar2 aic bic se cells(b(star fmt(2)) se(par fmt(2))) scalars(F)
eststo clear
restore


*______________________________
*	Table B6: Ethnicity-level Deep Christianization, Cousin Terms and Cousin marriage

local x co_deepchrist
foreach y of var CousinMarriage_Pref CousinTerm_Dif NonInuit_Term {

eststo: reg `y' `x'      , cluster(language_family)
eststo: reg `y' `x' `a'  , cluster(language_family)
eststo: reg `y' `x' `a' `a2' , cluster(language_family)
eststo: reg `y' `x' `a' `a2' `b' , cluster(language_family)
eststo: reg `y' `x' `a' `a2' `b' `c' , cluster(language_family)
eststo: reg `y' `x' `a' `a2' `b' `c' `d', cluster(language_family)
eststo: xi: reg `y' `x' `a' `a2' `b' `c' `d' i.therm_clim, cluster(language_family)
psacalc delta `x', rmax(0.48) beta(0)
esttab using tables\TableB6_`y'.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 ar2 aic bic se cells(b(star fmt(2)) se(par fmt(2))) scalars(F)
eststo clear
}
